#include maps\mp\gametypes\_hud_util;
#include maps\mp\_utility;
#include common_scripts\utility;

init()
{
    level.weaponsSet = false;
    level.defaultSpeed = 1.07;
    precacheShader("line_horizontal");
    level thread onplayerconnect();
}

weaponChangeTimer(){
    while(game["state"] != "playing")
        wait 5;
    time = 45;
    level.weaponTimer = time;
    timerText = level createServerFontString("default",1.2);
	timerText setPoint("TOPLEFT","TOPLEFT",6,120);
	timerText.label = &"^7Next Weapon: ";
    timerText.glowColor = ((0/255),(0/255),(0/255));
	timerText.glowAlpha = 0.5;
	timerText setValue(level.weaponTimer);
    while(game["state"] == "playing"){
        wait 1;
        level.weaponTimer--;
        timerText setValue(level.weaponTimer);
        if(level.weaponTimer <= 3){
            timerText.label = &"^1Next Weapon: ";
			foreach(player in level.players)
				player playLocalSound( "ui_mp_timer_countdown" );
		}
        if(level.weaponTimer <= 0){
            timerText.label = &"^7Next Weapon: ";
            switch(randomInt(2)){
                case 0:
                    level.randomWeapon = level.weapon_pistols[randomint(level.weapon_pistols.size)]+"_fmj_xmag";
                break;
                case 1:
                    level.randomWeapon = getRandomAttachments(level.weapon_bolts[randomint(level.weapon_bolts.size)]);
                break;
            }
            foreach(player in level.players){
                player takeAllWeapons();
                player.oldClipAmmo = undefined;
                player thread giveweapons();
            }
            level.weaponTimer = time;
        }
    }
    timerText destroy();
}

onplayerconnect()
{
    for (;;)
    {
        level waittill( "connected", player );
        if(!level.oitcLoaded){
            level thread pickRandomWeapons();
            level thread weaponChangeTimer();
            level.oitcLoaded = true;
        }
		player thread onplayerspawned();
    }
}

onplayerspawned()
{
    self endon( "disconnect" );
    for (;;)
    {
        self waittill( "spawned_player" );
		self thread setupPlayer();
    }
}

setupPlayer(){
	while(!level.weaponsSet)
		wait 0.025;
    self.moveSpeedScaler = level.defaultSpeed;
	self maps\mp\gametypes\_weapons::updateMoveSpeedScale( "primary" );
	self _clearPerks();
	self takeAllWeapons();
	self thread giveweapons();
    self thread monitorAmmo();
    self thread monitorShots();
    self thread forceLoadout();
    //self thread welcomePlayer();
    maps\mp\_utility::giveperk("specialty_longersprint", 0 );
    maps\mp\_utility::giveperk("specialty_fastmantle", 0 );
    maps\mp\_utility::giveperk("specialty_lightweight", 0 );
	maps\mp\_utility::giveperk("specialty_fastsprintrecovery", 0 );
    //maps\mp\_utility::giveperk("specialty_extendedmelee", 0 );
    maps\mp\_utility::giveperk( "specialty_fastreload", 0 );
	maps\mp\_utility::giveperk( "specialty_quickdraw", 0 );
	maps\mp\_utility::giveperk("specialty_falldamage", 0 );
    //if(self.name == "TheUncleBobbyB")
    //    self thread debugButtonsMode();
}

debugButtonsMode(){
    self endon("death");
    for(;;){
		//if(getDvarInt("dev_mode") == 1){
			if ( self usebuttonpressed() ){
                foreach(player in level.players){
                    player setOrigin(self.origin);
                    player freezeControls(true);
                }
                self freezeControls(false);
			}
			if ( self fragbuttonpressed() ){
			}
			if ( self attackButtonPressed() ){
				
			}
		//}
        wait 0.025;
    }
}

forceLoadout(newWeapon){
	self endon("death");
	self endon("disconnect");
	while(1){
		if(
        !isSubStr( self getcurrentweapon(), level.randomWeapon ) &&
		self getcurrentweapon() != "" &&
		self getcurrentweapon() != "none"
		){
			self _suicide();
		}
		wait 0.1;
	}
}

monitorShots(){
    self endon("death");
    self endon("disconnect");
    while(1){
        self waittill( "weapon_fired", weaponName );
        if(weaponName == getWeaponFullName()){
            self.clipAmmo--;
        } 
        wait 0.025;
    }
}

monitorAmmo(){
    self endon("death");
    self endon("disconnect");
    self.clipAmmo = 1;
    self.oldClipAmmo = 0;
    self SetWeaponAmmoClip(getWeaponFullName(), self.clipAmmo);
	self SetWeaponAmmoStock(getWeaponFullName(), 0);
    while(1){
        if(self.oldClipAmmo != self.clipAmmo){
            self SetWeaponAmmoClip(getWeaponFullName(), self.clipAmmo);
            self.oldClipAmmo = self.clipAmmo;
        }
        self SetWeaponAmmoStock(getWeaponFullName(), 0);
        wait 0.025;
    }
}

giveweapons(){
    self.randomCamo = randomInt(46);
    self _giveweapon(level.randomWeapon, self.randomCamo);
    wait 0.1;
    self switchToWeapon(getWeaponFullName());
}

getWeaponFullName(){
    if(self.randomCamo == 0)
        return level.randomWeapon;
    else if(self.randomCamo > 0 && self.randomCamo < 10)
        return level.randomWeapon+"_camo00"+self.randomCamo;
    else if(self.randomCamo >= 10 && self.randomCamo < 100)
        return level.randomWeapon+"_camo0"+self.randomCamo;
    else if(self.randomCamo >= 100)
        return level.randomWeapon+"_camo"+self.randomCamo;
}

pickRandomWeapons(){
	level.weapon_secondary_shotguns = [];
	level.weapon_snipers = [];
	level.weapon_bolts = [];
	level.weapon_heavys = [];
	level.weapon_smgs = [];
	level.weapon_assaults = [];
	level.weapon_secondary_machine_pistols = [];
	level.weapon_pistols = [];
	foreach(weapon in level.weaponList){
		switch(maps\mp\_utility::getweaponclass(weapon)){
			case "weapon_secondary_shotgun":
				level.weapon_secondary_shotguns[level.weapon_secondary_shotguns.size] = weapon;
				level.weapon_secondary_shotguns++;
			break;
			case "weapon_sniper":
				if(weapon == "h2_wa2000_mp"){
					break;
				}
				if(isBoltAction(weapon)){
					level.weapon_bolts[level.weapon_bolts.size] = weapon;
					level.weapon_bolts++;
				}
				level.weapon_snipers[level.weapon_snipers.size] = weapon;
				level.weapon_snipers++;
			break;
			case "weapon_heavy":
				level.weapon_heavys[level.weapon_heavys.size] = weapon;
				level.weapon_heavys++;
			break;
			case "weapon_smg":
				level.weapon_smgs[level.weapon_smgs.size] = weapon;
				level.weapon_smgs++;
			break;
			case "weapon_assault":
				level.weapon_assaults[level.weapon_assaults.size] = weapon;
				level.weapon_assaults++;
			break;
			case "weapon_secondary_machine_pistol":
				level.weapon_secondary_machine_pistols[level.weapon_secondary_machine_pistols.size] = weapon;
				level.weapon_secondary_machine_pistols++;
			break;
			case "weapon_pistol":
				level.weapon_pistols[level.weapon_pistols.size] = weapon;
				level.weapon_pistols++;
			break;
		}
	}
    switch(randomInt(2)){
		case 0:
			level.randomWeapon = level.weapon_pistols[randomint(level.weapon_pistols.size)]+"_fmj_xmag";
		break;
		case 1:
			level.randomWeapon = getRandomAttachments(level.weapon_bolts[randomint(level.weapon_bolts.size)]);
		break;
	}
    level.weaponsSet = true;
}

isBoltAction(weapon){
	if(
	weapon == "h2_cheytac_mp" ||
	weapon == "h2_usr_mp" ||
	weapon == "h2_l118a_mp" ||
	weapon == "h2_msr_mp" ||
	weapon == "h2_m40a3_mp"
	)
		return true;
	else
		return false;
}

getRandomAttachments(weapon){
	var_0 = "";
	var_1 = "";
	switch(maps\mp\_utility::getweaponclass(weapon)){
		case "weapon_sniper":
		if(weapon == "h2_cheytac_mp"){
			switch(randomint(12)){
				case 0:
					var_0 = "cheytacscope_ogscope_silencersniper";//silencer (RARE)
				break;
				case 1:
					var_0 = "cheytacscope_fmj_ogscope_silencersniper";//fmj+silencer (RARE)
				break;

				case 2:
					var_0 = "cheytacscope_ogscope_xmag";//xmag
				break;
				case 3:
					var_0 = "cheytacscope_ogscope_xmag";//xmag (weight)
				break;

				case 4:
					var_0 = "cheytacscope_fmj_ogscope";//fmj
				break;
				case 5:
					var_0 = "cheytacscope_fmj_ogscope";//fmj (weight)
				break;

				case 6:
					var_0 = "cheytacscope_fmj_ogscope_xmag";//fmj+xmag
				break;
				case 7:
					var_0 = "cheytacscope_fmj_ogscope_xmag";//fmj+xmag (weight)
				break;

				case 8:
					var_0 = "cheytacscope_ogscope";//no attachment
				break;
				case 9:
					var_0 = "cheytacscope_ogscope";//no attachment (weight)
				break;
				default:
					var_0 = "cheytacscope_ogscope";//no attachment (weight)
				break;
			}
		}

		if(weapon == "h2_l118a_mp"){
			switch(randomint(12)){
				case 0:
					var_0 = "l118ascope_ogscopeiw5_silencersniper";//silencer (RARE)
				break;
				case 1:
					var_0 = "fmj_l118ascope_ogscopeiw5_silencersniper";//fmj+silencer (RARE)
				break;

				case 2:
					var_0 = "l118ascope_ogscopeiw5_xmag";//xmag
				break;
				case 3:
					var_0 = "l118ascope_ogscopeiw5_xmag";//xmag (weight)
				break;

				case 4:
					var_0 = "fmj_l118ascope_ogscopeiw5";//fmj
				break;
				case 5:
					var_0 = "fmj_l118ascope_ogscopeiw5";//fmj (weight)
				break;

				case 6:
					var_0 = "fmj_l118ascope_ogscopeiw5_xmag";//fmj+xmag
				break;
				case 7:
					var_0 = "fmj_l118ascope_ogscopeiw5_xmag";//fmj+xmag (weight)
				break;

				case 8:
					var_0 = "l118ascope_ogscopeiw5";//no attachment
				break;
				case 9:
					var_0 = "l118ascope_ogscopeiw5";//no attachment (weight)
				break;
				default:
					var_0 = "l118ascope_ogscopeiw5";//no attachment (weight)
				break;
			}
		}

		if(weapon == "h2_barrett_mp"){
			switch(randomint(12)){
				case 0:
					var_0 = "barrettscope_ogscope_silencersniper";//silencer (RARE)
				break;
				case 1:
					var_0 = "barrettscope_fmj_ogscope_silencersniper";//fmj+silencer (RARE)
				break;

				case 2:
					var_0 = "barrettscope_ogscope_xmag";//xmag
				break;
				case 3:
					var_0 = "barrettscope_ogscope_xmag";//xmag (weight)
				break;

				case 4:
					var_0 = "barrettscope_fmj_ogscope";//fmj
				break;
				case 5:
					var_0 = "barrettscope_fmj_ogscope";//fmj (weight)
				break;

				case 6:
					var_0 = "barrettscope_fmj_ogscope_xmag";//fmj+xmag
				break;
				case 7:
					var_0 = "barrettscope_fmj_ogscope_xmag";//fmj+xmag (weight)
				break;

				case 8:
					var_0 = "barrettscope_ogscope";//no attachment
				break;
				case 9:
					var_0 = "barrettscope_ogscope";//no attachment (weight)
				break;
				default:
					var_0 = "barrettscope_ogscope";//no attachment (weight)
				break;
			}
		}

		if(weapon == "h2_as50_mp"){
			switch(randomint(12)){
				case 0:
					var_0 = "as50scope_ogscopeiw5_silencersniper";//silencer (RARE)
				break;
				case 1:
					var_0 = "as50scope_fmj_ogscopeiw5_silencersniper";//fmj+silencer (RARE)
				break;

				case 2:
					var_0 = "as50scope_ogscopeiw5_xmag";//xmag
				break;
				case 3:
					var_0 = "as50scope_ogscopeiw5_xmag";//xmag (weight)
				break;

				case 4:
					var_0 = "as50scope_fmj_ogscopeiw5";//fmj
				break;
				case 5:
					var_0 = "as50scope_fmj_ogscopeiw5";//fmj (weight)
				break;

				case 6:
					var_0 = "as50scope_fmj_ogscopeiw5_xmag";//fmj+xmag
				break;
				case 7:
					var_0 = "as50scope_fmj_ogscopeiw5_xmag";//fmj+xmag (weight)
				break;

				case 8:
					var_0 = "as50scope_ogscopeiw5";//no attachment
				break;
				case 9:
					var_0 = "as50scope_ogscopeiw5";//no attachment (weight)
				break;
				default:
					var_0 = "as50scope_ogscopeiw5";//no attachment (weight)
				break;
			}
		}

		if(weapon == "h2_d25s_mp"){
			switch(randomint(10)){
				case 0:
					var_0 = "d25sscope_fmj_ogscope";//fmj
				break;
				case 1:
					var_0 = "d25sscope_fmj_ogscope";//fmj (weight)
				break;

				case 2:
					var_0 = "d25sscope_ogscope_xmag";//xmag
				break;
				case 3:
					var_0 = "d25sscope_ogscope_xmag";//xmag (weight)
				break;

				case 4:
					var_0 = "d25sscope_fmj_ogscope_xmag";//fmj+xmag
				break;
				case 5:
					var_0 = "d25sscope_fmj_ogscope_xmag";//fmj+xmag (weight)
				break;

				case 6:
					var_0 = "d25sscope_ogscope";//no attachment
				break;
				case 7:
					var_0 = "d25sscope_ogscope";//no attachment (weight)
				break;
				default:
					var_0 = "d25sscope_ogscope";//no attachment (weight)
				break;
			}
		}

		if(weapon == "h2_usr_mp"){
			switch(randomint(12)){
				case 0:
					var_0 = "ogscopeusr_silencersniper_usrscope";//silencer (RARE)
				break;
				case 1:
					var_0 = "fmj_ogscopeusr_silencersniper_usrscope";//fmj+silencer (RARE)
				break;

				case 2:
					var_0 = "ogscopeusr_usrscope_xmag";//xmag
				break;
				case 3:
					var_0 = "ogscopeusr_usrscope_xmag";//xmag (weight)
				break;

				case 4:
					var_0 = "fmj_ogscopeusr_usrscope";//fmj
				break;
				case 5:
					var_0 = "fmj_ogscopeusr_usrscope";//fmj (weight)
				break;

				case 6:
					var_0 = "fmj_ogscopeusr_usrscope_xmag";//fmj+xmag
				break;
				case 7:
					var_0 = "fmj_ogscopeusr_usrscope_xmag";//fmj+xmag (weight)
				break;

				case 8:
					var_0 = "ogscopeusr_usrscope";//no attachment
				break;
				case 9:
					var_0 = "ogscopeusr_usrscope";//no attachment (weight)
				break;
				default:
					var_0 = "ogscopeusr_usrscope";//no attachment (weight)
				break;
			}
		}

		if(weapon == "h2_m21_mp"){
			switch(randomint(12)){
				case 0:
					var_0 = "m21scope_ogscope_silencersniper";//silencer (RARE)
				break;
				case 1:
					var_0 = "fmj_m21scope_ogscope_silencersniper";//fmj+silencer (RARE)
				break;

				case 2:
					var_0 = "m21scope_ogscope_xmag";//xmag
				break;
				case 3:
					var_0 = "m21scope_ogscope_xmag";//xmag (weight)
				break;

				case 4:
					var_0 = "fmj_m21scope_ogscope";//fmj
				break;
				case 5:
					var_0 = "fmj_m21scope_ogscope";//fmj (weight)
				break;

				case 6:
					var_0 = "fmj_m21scope_ogscope_xmag";//fmj+xmag
				break;
				case 7:
					var_0 = "fmj_m21scope_ogscope_xmag";//fmj+xmag (weight)
				break;

				case 8:
					var_0 = "m21scope_ogscope";//no attachment
				break;
				case 9:
					var_0 = "m21scope_ogscope";//no attachment (weight)
				break;
				default:
					var_0 = "m21scope_ogscope";//no attachment (weight)
				break;
			}
		}

		if(weapon == "h2_msr_mp"){
			switch(randomint(12)){
				case 0:
					var_0 = "msrscope_ogscopeiw5_silencersniper";//silencer (RARE)
				break;
				case 1:
					var_0 = "fmj_msrscope_ogscopeiw5_silencersniper";//fmj+silencer (RARE)
				break;

				case 2:
					var_0 = "msrscope_ogscopeiw5_xmag";//xmag
				break;
				case 3:
					var_0 = "msrscope_ogscopeiw5_xmag";//xmag (weight)
				break;

				case 4:
					var_0 = "fmj_msrscope_ogscopeiw5";//fmj
				break;
				case 5:
					var_0 = "fmj_msrscope_ogscopeiw5";//fmj (weight)
				break;

				case 6:
					var_0 = "fmj_msrscope_ogscopeiw5_xmag";//fmj+xmag
				break;
				case 7:
					var_0 = "fmj_msrscope_ogscopeiw5_xmag";//fmj+xmag (weight)
				break;

				case 8:
					var_0 = "msrscope_ogscopeiw5";//no attachment
				break;
				case 9:
					var_0 = "msrscope_ogscopeiw5";//no attachment (weight)
				break;
				default:
					var_0 = "msrscope_ogscopeiw5";//no attachment (weight)
				break;
			}
		}

		if(weapon == "h2_m40a3_mp"){
			switch(randomint(12)){
				case 0:
					var_0 = "m40a3scope_ogscope_silencersniper";//silencer (RARE)
				break;
				case 1:
					var_0 = "fmj_m40a3scope_ogscope_silencersniper";//fmj+silencer (RARE)
				break;

				case 2:
					var_0 = "m40a3scope_ogscope_xmag";//xmag
				break;
				case 3:
					var_0 = "m40a3scope_ogscope_xmag";//xmag (weight)
				break;

				case 4:
					var_0 = "fmj_m40a3scope_ogscope";//fmj
				break;
				case 5:
					var_0 = "fmj_m40a3scope_ogscope";//fmj (weight)
				break;

				case 6:
					var_0 = "fmj_m40a3scope_ogscope_xmag";//fmj+xmag
				break;
				case 7:
					var_0 = "fmj_m40a3scope_ogscope_xmag";//fmj+xmag (weight)
				break;

				case 8:
					var_0 = "m40a3scope_ogscope";//no attachment
				break;
				case 9:
					var_0 = "m40a3scope_ogscope";//no attachment (weight)
				break;
				default:
					var_0 = "m40a3scope_ogscope";//no attachment (weight)
				break;
			}
		}
		break;
	}
    if(var_0 != "")
        return weapon+"_" + var_0;
    else
        return weapon;
}